# MDP domains generator

## List of supported domains

- Mountain Car (mcar)
- Single Arm Pendulum (sap)
- Double Arm Pendulum (dap)
- Triple Arm Pendulum (tap)
- SysAdmin

## Usage

- Compile the generators with `make`
- Run `./make_tests.pl` (requires perl interpretor) to generate the domains
- Note: It is possible to change the number of states of each domain in `make_tests.pl`

## File format

```
num_states
  state_id num_applicable_actions
    action_reward num_possible_outcomes
      neighbor_1 proba_1
      ...
    ...
  ...
```

- The actual printing of the generated MDPs is done in `cont_world.c:compute_transitions`
- Some MDPs have dead-ends (non-goal states with no action / action with no outcomes)
- All goal states have a transition to an artificial goal state (last state in file)
- E.g., in mcar with 10000 states, "state" 10001 is the goal state to use

## References

- The files in this folder come from David Wingate
- See e.g., **D. Wingate, K. Seppi, Efficient value iteration using partitioned models, in: Proceedings of the International Conference on Machine Learning and Applications, ICMLA 03, 2003, pp. 53–59.**
