#ifndef POINT_H
#define POINT_H

#include <iostream>

class Point {
 public:
  Point();
  Point(double lati, double longi);

  double distance(const Point&) const;
  Point getPointMilieu(const Point& p) const;

  Point& operator+=(const Point&);

  const double& operator[](size_t dim) const;
  double& operator[](size_t dim);

 private:
  double latitude;
  double longitude;

  friend std::ostream& operator<<(std::ostream&, const Point&);
  friend std::istream& operator>>(std::istream&, Point&);
};

#endif
