#include "Ve.hpp"

using namespace std;

pair<minutes,minutes> Ve::computeHopCost(meters distance) const
{
  if(distance <= autonomy)
    return {computeTravelUnbounded(distance),
            static_cast<minutes>(ceil(static_cast<double>(distance) * chargePerMeters))};

  return {numeric_limits<minutes>::max(), numeric_limits<minutes>::max()};
}

minutes Ve::computeTravelUnbounded(meters distance) const
{
  return static_cast<minutes>(ceil(static_cast<double>(distance) / static_cast<double>(averageSpeed)));
}

veId Ve::getId() const { return id; }
nodeId Ve::getStart() const { return start; }
nodeId Ve::getDest() const { return dest; }
meters Ve::getAutonomy() const { return autonomy; }
minutes Ve::getStartTime() const { return startTime; }
speed Ve::getAverageSpeed() const { return averageSpeed; }
double Ve::getInvertedAverageSpeed() const { return invertedAverageSpeed; }
minutes Ve::getFullChargeTime() const { return fullChargeTime; }
double Ve::getChargePerMeters() const { return chargePerMeters; }
