# EV Coroadperation

## About

This folder contains the code associated with the *Cooperative Electric Vehicles Planning*
paper presented at [AAMAS 2024](https://www.aamas2024-conference.auckland.ac.nz/).
More ressources is available on the paper's [official page](https://jaelgareau.com/en/publication/gareau-aamas24).

## Dependencies

- [g++](https://gcc.gnu.org/) (>= 10)

## Usage

- Run `make [DEBUG=1] [PROFILER=1]` to compile the code
- Use `ulimit -s unlimited` to prevent a stack overflow on recursive functions.
- Type `./veCoop -h` to show the available flags.

# Usage examples

- Generate some requests: `./veCoop -f ./tests/quebecL3.graphe -g 10 -n 20 -m 1 > test.req`
- Evaluate some requests: `./veCoop -f ./tests/quebecL3.graphe -r test.req -s coopLogFact`

# Format

- Requests input format:
    - Requests are separated by a `===` line.
    - Each request contains one line per EV:
        - "starting time", "starting node", "destination node", "EV range"

- Output format:
    - One line per request:
        - "travel time", "charging time", "waiting time", "total distance", "penalty"
