#!/usr/bin/awk -f

BEGIN { OFS="\t" }

NR <= 10 {
  # --- Var states data ---
  if ($7 !~ "-" && $9 != "-") {
    VI_s += $5
    TVI_s += $11
    eTVI_s += $13
    eiTVI_s += $15
  } else {
    print "Ignored line:", $1 > "/dev/stderr"
  }
}

NR >= 11 && NR <= 25 {
  # --- Var layers data ---
  if ($7 !~ "-" && $9 != "-") {
    VI_l += $5
    TVI_l += $11
    eTVI_l += $13
    eiTVI_l += $15
  } else {
    print "Ignored line:", $1 > "/dev/stderr"
  }
}

NR >= 26 && NR <= 35 {
  # --- SAP data ---
  if ($7 !~ "-" && $9 != "-") {
    VI_sap += $5
    TVI_sap += $11
    eTVI_sap += $13
    eiTVI_sap += $15
  } else {
    print "Ignored line:", $1 > "/dev/stderr"
  }
}

NR >= 36 {
  # --- Wetfloor data ---
  if ($7 !~ "-" && $9 != "-") {
    VI_w += $5
    TVI_w += $11
    eTVI_w += $13
    eiTVI_w += $15
  } else {
    print "Ignored line:", $1 > "/dev/stderr"
  }
}

END {
  VI    = VI_s    + VI_l    + VI_sap    + VI_w;
  TVI   = TVI_s   + TVI_l   + TVI_sap   + TVI_w;
  eTVI  = eTVI_s  + eTVI_l  + eTVI_sap  + eTVI_w;
  eiTVI = eiTVI_s + eiTVI_l + eiTVI_sap + eiTVI_w;

  print "Domain"    , "TVI vs VI"      , "eTVI vs TVI"      , "eiTVI vs eTVI"      , "eiTVI vs TVI"
  print "Layered-s" , VI_s / TVI_s     , TVI_s / eTVI_s     , eTVI_s / eiTVI_s     , TVI_s / eiTVI_s
  print "Layered-l" , VI_l / TVI_l     , TVI_l / eTVI_l     , eTVI_l / eiTVI_l     , TVI_l / eiTVI_l
  print "SAP"       , VI_sap / TVI_sap , TVI_sap / eTVI_sap , eTVI_sap / eiTVI_sap , TVI_sap / eiTVI_sap
  print "Wetfloor"  , VI_w / TVI_w     , TVI_w / eTVI_w     , eTVI_w / eiTVI_w     , TVI_w / eiTVI_w
  print "Average"   , VI / TVI         , TVI / eTVI         , eTVI / eiTVI         , TVI / eiTVI
}
