#!/usr/bin/perl

my $type = $ARGV[0];
system( "mkdir -p domains/$type" );

if($type eq 'mcar') {
    @divs = ( 100, 300, 500, 700, 1000, 1400 );
    foreach $d ( @divs ) {
        $dsq = $d*$d;
        $cmd = "./g_mcar --dd0=$d --dd1=$d --discount_factor=0.6 --use_variable_timestep --base_timestep=0.001 > domains/mcar/$dsq.mdp";
        print STDERR "MCAR - $dsq\n";
        system( $cmd );
    }
} elsif($type eq 'sap') {
    @divs = ( 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000 );
    foreach $d ( @divs ) {
        $dsq = $d*$d;
        $cmd = "./g_sap --dd0=$d --dd1=$d --discount_factor=0.6 --use_variable_timestep --base_timestep=0.001 > domains/sap/$dsq.mdp";
        print STDERR "SAP - $dsq\n";
        system( $cmd );
    }
} elsif($type eq 'dap') {
    @divs = ( 10, 20, 32 );
    foreach $d ( @divs ) {
        $df = $d*$d*$d*$d;
        $cmd = "./g_dap --dd0=$d --dd1=$d --dd2=$d --dd3=$d --discount_factor=0.6 --use_variable_timestep --base_timestep=0.001 > domains/dap/$df.mdp";
        print STDERR "DAP - $df\n";
        system( $cmd );
    }
} elsif($type eq 'tap') {
    @divs = ( 5, 6, 7, 8 );
    foreach $d ( @divs ) {
        $ds = $d*$d*$d*$d*$d*$d;
        $cmd = "./g_tap --dd0=$d --dd1=$d --dd2=$d --dd3=$d --dd4=$d --dd5=$d --discount_factor=0.99 --use_variable_timestep --base_timestep=0.001 > domains/tap/$ds.mdp";
        print STDERR "TAP - $ds\n";
        system( $cmd );
    }
} elsif($type eq 'sysadmin') {
    @divs = ( 5, 10, 11, 12 );
    foreach $d ( @divs ) {
        $n = 2 ** $d;
        $cmd = "./sysadmin.pl $d > domains/sysadmin/$n.mdp";
        print STDERR "SYSADMIN - $n\n";
        system( $cmd );
    }
} else {
    print STDERR "Unrecognized MDP type\n";
}
