#include "algo.hpp"

using namespace std;

globalSolution runOptimal(const Graph& nodeGraph, const vector<Ve>& vehicleList)
{
  // Computing reference for each vehicle, no coop, no wait
  vector<minutes> referencesTimes;
  for(const auto& currentVe : vehicleList)
    referencesTimes.push_back(get<1>(AStar<TypeReserv::noReserve>(nodeGraph, currentVe)));

  const vector<unitarySolution> results = calculerN4(nodeGraph, vehicleList);

  double penalty = 0;
  for(size_t currentVehicleId = 0; currentVehicleId < size(results); ++currentVehicleId)
  {
    const double difference
      = static_cast<double>(get<1>(results[currentVehicleId]) - referencesTimes[currentVehicleId]);
    penalty += difference * difference;
  }

  const double tmpVehicleListSize = static_cast<double>(size(vehicleList));
  penalty /= tmpVehicleListSize;

  return {results, penalty};
}

void SimulateWaiting(const Graph& nodeGraph, const vector<Ve>& veList,
                     vector<unitarySolution>& results)
{
  queue<nodeId> nodeIdQueue;

  // Adding all node to queue
  for(nodeId nid = 0; nid < nodeGraph.getNodeCount(); ++nid)
    nodeIdQueue.push(nid);

  while(!nodeIdQueue.empty())
  {
    const nodeId currentNode = nodeIdQueue.front();
    nodeIdQueue.pop();

    unordered_set<nodeId> toRecheck;

    for(const auto& [modifiedVe, difference] : nodeGraph.fixNode(currentNode))
    {

      // Drifting all nodes after the current one and requeue them for check
      const auto& currentSol = get<0>(results[modifiedVe]);
      size_t start = 0;
      while(currentSol[start] != currentNode)
        ++start;

      // If end not reached
      if(start != size(currentSol) - 1)
      {
        ++start;
        while(start < currentSol.size())
        {
          nodeGraph.driftBooking(currentSol[start],modifiedVe,difference);
          toRecheck.insert(currentSol[start]);
          ++start;
        }
      }
    }

    // Repushing altered nodes
    for(const auto& current : toRecheck)
      nodeIdQueue.push(current);
  }

  //Updating travel times
  for(veId currentVe = 0; currentVe < size(results); ++currentVe)
  {
    auto& [vePlan, veTime, _] = results[currentVe];
    if(size(vePlan) > 0)
      veTime = nodeGraph.getBooking(vePlan.back(),
                                    currentVe).first - veList[currentVe].getStartTime();
  }
}
