#pragma once

#include <cmath>

#include "types.hpp"

constexpr speed averageSpeed          = 1667;
constexpr double invertedAverageSpeed = 1.0 / 1667.0;
constexpr double chargePerMeters      = 1.0 / 8660.0;

class Ve
{
  private:
    nodeId start;
    nodeId dest;
    meters autonomy;
    minutes startTime;
    veId id;
    bool active;

    //in meters per minutes
    minutes fullChargeTime = 0;

  public:
    Ve(veId _id, nodeId _start, nodeId _dest, meters _autonomy, minutes _startTime) :
      start(_start), dest(_dest), autonomy(_autonomy),
      startTime(_startTime), id(_id), active(true)
    {
      fullChargeTime = static_cast<minutes>(ceil(static_cast<double>(autonomy) / 8660.0));
    }

    std::pair<minutes, minutes> computeHopCost(meters distance) const;
    minutes computeTravelUnbounded(meters distance) const;

    veId getId() const;
    nodeId getStart() const;
    nodeId getDest() const;
    meters getAutonomy() const;
    minutes getStartTime() const;

    speed getAverageSpeed() const;
    double getInvertedAverageSpeed() const;
    minutes getFullChargeTime() const;
    double getChargePerMeters() const;
};
